
#ifndef MW_ATP_UTIL_FUNCS_H
#define MW_ATP_UTIL_FUNCS_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

#include "MW_ATP_defines.h"

/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 07 10:27:43 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_funcs.h#1:incl:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
#define ATP_EXIT_TEST_AFTER_FAILURE  NO_DEBUG
#define NO_DEBUG 1
#define LOW_DEBUG 2
#define HIGH_DEBUG 3


#define TST_ATP_CHECK_ERROR_RETURN(CurrentResult,FunName,LocalTestName,MainTestName)\
if((TST_ATP_CheckErrorReturn(CurrentResult,(DxChar_t*)FunName,(DxChar_t*)LocalTestName,(DxChar_t*)MainTestName) != TST_PASS)&& ATP_EXIT_TEST_AFTER_FAILURE <= LOW_DEBUG)\
  {goto EXIT_ON_ERROR;}



// TST_ATP_CheckErrorReturn((DxError_t)CurrentResult,(DxChar_t*)FunName,(DxChar_t*)LocalTestName,(DxChar_t*)MainTestName); 
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
/******** Public Variables ********/
/******** Public Functions ********/

/**********************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_ParseArgs
 *
 * Inputs:
 *     int argc - number of arguments in argv
 *     char *argv[] - the arguments given to the application
 *  
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * The following function handles the parsing of the arguemnts by setting the
 * global variables affected by them.
 *
 **********************************************************************************/
DxError_t MW_ATP_UTIL_ParseArgs(int argc, char *argv[]);

/********************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_Init_CRYS
 *
 * Inputs:
 *  None.
 *  
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * The following function handles the initialization of the CryptoCell and CRYS.
 *
 ********************************************************************************/
DxError_t MW_ATP_UTIL_Init_CRYS(void);

/********************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_Init_SEP
 *
 * Inputs:
 *  None.
 *  
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * The following function handles the initialization of the SEP and CryptoCell.
 *
 ********************************************************************************/
DxError_t MW_ATP_UTIL_Init_SEP( void );

/* Macro defining when to return on error */
#define MW_ATP_RETURN_ON_FAILURE(_MW_ATP_RESULT)  \
    if ( (_MW_ATP_RESULT) != TST_PASS )            \
    {                                           \
        return (_MW_ATP_RESULT);                   \
    }

/********************************************************************************
 * Function Name:                                                           
 *   ATP_LOG_TST_PRINT     
 * 
 * Inputs:
 *   DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *   const char format,... - the printf format.   
 *  
 * Outputs:
 *   None                      
 *
 * Description:                                  
 * The following function handles the printings logging of the testing suite . 
 *        This function should be called by using the ATP_LOG_TST_PLOT macro
 *
 ********************************************************************************/                   
    #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        int ATP_LOG_TST( DxUint8_t level , const char *format,... );
    #endif

    #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        #define ATP_LOG_TST_PRINT(args) (ATP_LOG_TST args)
    #else
        #define ATP_LOG_TST_PRINT(args)   
    #endif                   

/********************************************************************************
 * Function Name:                                                           
 *   ATP_LOG_DEV_DisplayBuffer     
 * 
 * Inputs:
 *   DxUint8_t  level - the printing level if it is below the CRYS_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *   char       Label - a label string.
 *  DxUint8_t  Buffer - the buffer to be printed.
 *  uint32_    Size  - the buffer size in bytes.
 *
 * Outputs:
 *   None
 *
 * Description:                                  
 *  The following function prints a buffer.
 *
 ********************************************************************************/
    #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        void ATP_LOG_TST_DisplayBuffer(DxUint8_t level , char  *Label,DxUint8_t *Buffer,DxUint32_t Size );
    #endif

    #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        #define ATP_LOG_TST_PRINT_DisplayBuffer(args) (ATP_LOG_TST_DisplayBuffer args)
    #else
        #define ATP_LOG_TST_PRINT_DisplayBuffer(args)   
    #endif


/********************************************************************************
 * Function Name:                                                           
 *   TST_CheckErrorReturn     
 * 
 * Inputs:
 *   DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char    TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char    TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 *   DxUint8_t - Function error return                        
 *
 * Description:                                  
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation has succeeded of failed  the appropriate printing and return value
 *
 ********************************************************************************/
DxError_t TST_ATP_CheckErrorReturn(DxError_t  TST_ErrorRet, 
                                     char         TST_FuncName[TST_FUNC_STRING_LEN],
                                     char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                     char         TST_MasterTestName[TST_FUNC_STRING_LEN]);


/********************************************************************************
 * Function Name:
 *  TST_ATP_GenCheckErrorReturn
 *
 * Inputs:
 *  DxError_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded of failed the appropriate printing and return value
 *
 ********************************************************************************/
#if 0
DxError_t TST_ATP_GenCheckErrorReturn(DxError_t  TST_ErrorRet,
                                      char         TST_FuncName[TST_FUNC_STRING_LEN],
                                      char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                      char         TST_MasterTestName[TST_FUNC_STRING_LEN]);
#endif

/*
*/
/*
*/
DxError_t MW_TST_Util_GetTime(DxUint32_t* TST_timeValue);

/*****************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_IncLsbUnsignedCounter
 *
 * Inputs:
 *  DxUint32_t *TST_CounterBuffPtr - The buffer containing the counter.
 *  DxUint32_t TST_Val - The value to add
 *  DxUint8_t  TST_ConterSize - the counter size in 32bit words
 *
 * Outputs:
 *   None
 *
 * Description:
 *     This function adds a value to a large counter presented in a buffer.
 *      The LSB of the counter is stored in the first cell in the array.
 *
 ******************************************************************************/                              
 void MW_ATP_UTIL_IncLsbUnsignedCounter(DxUint32_t *TST_CounterBuffPtr,
                                        DxUint32_t TST_Val,
                                        DxUint8_t  TST_CounterSize );


 /*****************************************************************************
 * Function Name:                                                           
 * MW_ATP_UTIL_CheckExpectedErrorReturn        
 * 
 * Inputs:
 *  DxUint32_t       ErrorRet                                 The return value of the checked function
 *  DxUint32_t       ExpectedError                            The expected return value of the checked function
 *  char             FuncName[TST_FUNC_STRING_LEN]            The checked function name 
 *  char             SubTestName[TST_FUNC_STRING_LEN]         The checked sub test name
 *  char             MasterTestName[TST_FUNC_STRING_LEN]      The checked main test name
 *
 * Outputs:
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 * The function returns the appropriate printing for a checked function
 * comparing the returned error result vs the expected error result. 
 ******************************************************************************/
 DxError_t MW_ATP_UTIL_CheckExpectedErrorReturn(DxError_t   ErrorRet, 
                                                DxError_t   ExpectedError, 
                                                char        FuncName[TST_FUNC_STRING_LEN],
                                                char        SubTestName[TST_FUNC_STRING_LEN],
                                                char        MasterTestName[TST_FUNC_STRING_LEN]);


/*
*/
#define GET_NON_WHITE_SPACE_CHAR(MW_ATP_UTIL_var) do                \
                {                                               \
                    MW_ATP_UTIL_var = DX_VOS_GetCh();           \
                } while((MW_ATP_UTIL_var==' ')||(MW_ATP_UTIL_var=='\r')||(MW_ATP_UTIL_var=='\n')||(MW_ATP_UTIL_var=='\t'))


 



#ifdef __cplusplus
}
#endif

#endif /*MW_ATP_UTIL_FUNCS_H*/

